
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import java.util.ArrayList;
import java.util.List;

public class Extension
{

	public final String otherURI;
	
	public Extension(String otherURI)
	{
		this.otherURI = otherURI;
	}

	public NodeList getSomeNodes()
	{
		ArrayNodeList nodeList = new ArrayNodeList( );

		try
		{
			Document doc = Test.loadDocument( otherURI );
			Element elem = doc.getDocumentElement();
			nodeList.add( elem );
		}
		catch (Exception e)
		{
			e.printStackTrace(System.err);
		}
		return nodeList;
	}
	
}


class ArrayNodeList implements NodeList
{

	private ArrayList list;

	ArrayNodeList()
	{
		list = new ArrayList();
	}

	ArrayNodeList(int size)
	{
		list = new ArrayList(size);
	}

	public int getLength()
	{
		return list.size();
	}

	public Node item(int x)
	{
		if (x < getLength())
			return (Node)list.get(x);
		else
			return null;
	}

	void add(Node node)
	{
		list.add(node);
	}

	void addAll(NodeList nodeList)
	{
		for (int i = 0; i < nodeList.getLength(); ++i)
		{
			add(nodeList.item(i));
		}
	}

}

