
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import java.io.File;
import java.io.StringWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.FileInputStream;
import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.SAXException;
import org.xml.sax.InputSource;

import org.apache.xerces.dom.DOMImplementationImpl;


public class Test
{

	public static void main(String args[])
	{
		try
		{
			String otherURI = "other.xml";
			String xsltURI = "test.xslt";
			String inputURI = "input.xml";

			if (args.length >= 1)
			{
				otherURI = args[0];
			}
			if (args.length >= 2)
			{
				xsltURI = args[1];
			}
			if (args.length >= 3)
			{
				inputURI = args[2];
			}

			Document xslDocument = loadDocument(xsltURI);
			Document inputDocument = loadDocument(inputURI);
			
			DOMSource xslSource = new DOMSource(xslDocument);
			xslSource.setSystemId(xsltURI);

			DOMSource inputSource = new DOMSource(inputDocument);
			inputSource.setSystemId(inputURI);

			TransformerFactory transformerFactory =
				TransformerFactory.newInstance();

			Templates templates = transformerFactory.newTemplates(xslSource);
			Transformer transformer = templates.newTransformer();

			transformer.setParameter( "ext",
				new Extension(otherURI) );

			DOMImplementation domImpl = new DOMImplementationImpl();
			Document doc = domImpl.createDocument(null, "outputRoot", null);
			Element root = doc.getDocumentElement();

			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);

			transformer.transform(inputSource, result);

			String str = writer.toString();
			System.out.println(str);


		}
		catch (Exception e)
		{
			e.printStackTrace(System.err);
		}
	}

	public static Document loadDocument(String filename)
		throws SAXException, IOException
	{
		File file = new File(filename);
		InputStream in = new FileInputStream(file);
		InputSource source = new InputSource(in);
		source.setSystemId(filename);
		
		DOMParser parser = new DOMParser();
		parser.setFeature("http://xml.org/sax/features/namespaces", true);

		parser.parse(source);

		return parser.getDocument();
	}
}


