<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	exclude-result-prefixes="xsl xsi ext xsltc"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform
	http://www.w3.org/1999/XSL/Transform"

	xmlns:xsltc="http://xml.apache.org/xalan/xsltc"
    xmlns:ext="xalan://Extension">

    <xsl:output method="html" version="4.01" media-type="text/html"
    	omit-xml-declaration="yes"
		doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
		doctype-system="http://www.w3.org/TR/html4/loose.dtd" />

	<xsl:param name="ext" />

	<xsl:template match="/">

		<xsl:variable
			name="ext2"
			select="xsltc:cast('Extension', $ext)" />

		<xsl:variable
			name="nodes1"
			select="/*" />
			
		<xsl:variable
			name="nodes2"
			select="ext:getSomeNodes($ext2)" />
			
		<html>
			<body>
				<p>	
					<div>
						<xsl:value-of
							select="count($nodes1)" />
					</div>
					<div>
						<xsl:value-of
							select="count($nodes2)" />
					</div>
				</p>
				<p>
					<div>
						<xsl:value-of
							select="$nodes1" />
					</div>
					<div>
						<xsl:value-of
							select="$nodes2" />
					</div>
				</p>
				<p>
					<div>
						<xsl:copy-of
							select="$nodes1" />
					</div>
					<div>
						<xsl:copy-of
							select="$nodes2" />
					</div>
				</p>
			</body>
		</html>
	</xsl:template>

</xsl:stylesheet>



